


############################################################
###
### Examples of use
###
### Cystic Fibrosis FEV & height percentile conversion tool
### R implementation
### Version 2.10
### (c) Michal Kulich 2007



##################################
## Example 1: Artificial data for 12 patients

ht <- c(174,158,170,147,174,165,132,138,165,174,124,152)
age <- c(16.7,25.4,19.7,8.4,13.8,16.1,8.1,8.8,14.9,29.6,7.1,22.0)
sex <- rep(c('m','f'),6)
fev <- c(3.326,1.736,3.666,3.910,3.186,2.857,2.096,1.555,2.168,
         1.419,1.534,0.961)

## display dataset
data.frame(age,ht,sex,fev)


## Transform FEV in liters into FEV quantiles

source('fevcalc-func.r')


##### Set reference period to 94_01
per <- "94_01"

# standardized by height and age
fevq <- fevperc(fevL=fev,age=age,ht=ht,sex=sex,period=per)

# standardized by height alone
fevq.ht <- fevperc(fevL=fev,ht=ht,sex=sex,period=per)

# standardized by age alone
fevq.age <- fevperc(fevL=fev,age=age,sex=sex,period=per)

## Transform height in cm into height quantiles (given age and sex)

htq <- htperc(ht=ht,age=age,sex=sex,period=per)

data.frame(age,ht,sex,fev,fevq,fevq.ht,fevq.age,htq)
#     age  ht sex   fev  fevq fevq.ht fevq.age   htq
# 1  16.7 174   m 3.326 0.554   0.743    0.690 0.722
# 2  25.4 158   f 1.736 0.536   0.439    0.511 0.340
# 3  19.7 170   m 3.666 0.836   0.884    0.781 0.389
# 4   8.4 147   f 3.910    NA   1.000    1.000 1.000
# 5  13.8 174   m 3.186 0.423   0.707    0.902 0.984
# 6  16.1 165   f 2.857 0.656   0.803    0.804 0.825
# 7   8.1 132   m 2.096 0.968   0.969    0.986 0.906
# 8   8.8 138   f 1.555 0.331   0.497    0.748 0.951
# 9  14.9 165   m 2.168 0.236   0.471    0.373 0.644
# 10 29.6 174   f 1.419 0.265   0.205    0.417 0.974
# 11  7.1 124   m 1.534 0.738   0.773    0.866 0.822
# 12 22.0 152   f 0.961 0.193   0.150    0.119 0.093
 

##### Set reference period to 99_06
per <- "99_06"

# standardized by height and age
fevq <- fevperc(fevL=fev,age=age,ht=ht,sex=sex,period=per)

# standardized by height alone
fevq.ht <- fevperc(fevL=fev,ht=ht,sex=sex,period=per)

# standardized by age alone
fevq.age <- fevperc(fevL=fev,age=age,sex=sex,period=per)

## Transform height in cm into height quantiles (given age and sex)

htq <- htperc(ht=ht,age=age,sex=sex,period=per)

data.frame(age,ht,sex,fev,fevq,fevq.ht,fevq.age,htq)
#     age  ht sex   fev  fevq fevq.ht fevq.age   htq
# 1  16.7 174   m 3.326 0.531   0.699    0.674 0.710
# 2  25.4 158   f 1.736 0.537   0.405    0.497 0.348
# 3  19.7 170   m 3.666 0.826   0.863    0.754 0.359
# 4   8.4 147   f 3.910    NA   1.000    1.000 1.000
# 5  13.8 174   m 3.186 0.429   0.656    0.892 0.980
# 6  16.1 165   f 2.857 0.637   0.785    0.794 0.830
# 7   8.1 132   m 2.096 0.967   0.969    0.987 0.913
# 8   8.8 138   f 1.555 0.322   0.468    0.724 0.946
# 9  14.9 165   m 2.168 0.201   0.406    0.349 0.632
# 10 29.6 174   f 1.419 0.206   0.180    0.383 0.971
# 11  7.1 124   m 1.534 0.770   0.778    0.879 0.836
# 12 22.0 152   f 0.961 0.194   0.124    0.113 0.097





###########################
## Example 2: Clinical trial eligibility criteria

## Suppose want FEV percentile (age-standardized) between 30 and 80.
## Ages to enroll: 6-18
## What are the FEV limits in liters?

## Set reference period to 99-06

age <- seq(6,18,by=0.5)
fevL <- fevperc(quan=c(0.3,0.8),age=age,sex="Female",per="99_06")

cbind(age,fevL)
#        age   0.3   0.8
#  [1,]  6.0 0.901 1.281
#  [2,]  6.5 0.909 1.300
#  [3,]  7.0 0.951 1.353
#  [4,]  7.5 1.010 1.427
#  [5,]  8.0 1.074 1.509
#  [6,]  8.5 1.130 1.589
#  [7,]  9.0 1.178 1.667
#  [8,]  9.5 1.222 1.746
#  [9,] 10.0 1.264 1.829
# [10,] 10.5 1.307 1.918
# [11,] 11.0 1.356 2.016
# [12,] 11.5 1.411 2.124
# [13,] 12.0 1.470 2.240
# [14,] 12.5 1.531 2.358
# [15,] 13.0 1.591 2.474
# [16,] 13.5 1.646 2.584
# [17,] 14.0 1.694 2.682
# [18,] 14.5 1.731 2.764
# [19,] 15.0 1.755 2.826
# [20,] 15.5 1.763 2.864
# [21,] 16.0 1.757 2.881
# [22,] 16.5 1.740 2.881
# [23,] 17.0 1.715 2.869
# [24,] 17.5 1.684 2.848
# [25,] 18.0 1.650 2.822


fevL <- fevperc(quan=c(0.3,0.8),age=age,sex="Male",per="99_06")

cbind(age,fevL)
#        age   0.3   0.8
#  [1,]  6.0 1.005 1.295
#  [2,]  6.5 0.995 1.345
#  [3,]  7.0 1.029 1.430
#  [4,]  7.5 1.089 1.532
#  [5,]  8.0 1.158 1.633
#  [6,]  8.5 1.220 1.720
#  [7,]  9.0 1.274 1.795
#  [8,]  9.5 1.323 1.863
#  [9,] 10.0 1.369 1.930
# [10,] 10.5 1.415 2.003
# [11,] 11.0 1.464 2.085
# [12,] 11.5 1.517 2.184
# [13,] 12.0 1.577 2.306
# [14,] 12.5 1.646 2.453
# [15,] 13.0 1.722 2.619
# [16,] 13.5 1.802 2.797
# [17,] 14.0 1.885 2.977
# [18,] 14.5 1.966 3.152
# [19,] 15.0 2.044 3.314
# [20,] 15.5 2.117 3.455
# [21,] 16.0 2.180 3.574
# [22,] 16.5 2.233 3.672
# [23,] 17.0 2.273 3.748
# [24,] 17.5 2.297 3.803
# [25,] 18.0 2.303 3.836



